Rem
Rem $Header: rdbms/demo/rac_wrappers/dbmsaqadshrd.sql /main/2 2010/04/22 23:33:33 swshekha Exp $
Rem
Rem dbmsaqadshrd.sql
Rem
Rem Copyright (c) 2009, 2010, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      dbmsaqadshrd.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    swshekha    09/29/09 - Created
Rem

SET FEEDBACK 1
SET NUMWIDTH 10
SET LINESIZE 80
SET TRIMSPOOL ON
SET TAB OFF
SET PAGESIZE 100

CREATE OR REPLACE PACKAGE dbms_aqadm_wrapper AUTHID CURRENT_USER AS

  --------------------
  --  PUBLIC CONSTANT
  --
  -- payload type of the queue table

  -- retention
  INFINITE             CONSTANT BINARY_INTEGER := -1;

  -- message grouping
  TRANSACTIONAL        CONSTANT BINARY_INTEGER := 1;
  NONE                 CONSTANT BINARY_INTEGER := 0;

  -- queue type
  NORMAL_QUEUE               CONSTANT BINARY_INTEGER := 0;
  EXCEPTION_QUEUE            CONSTANT BINARY_INTEGER := 1;
  NON_PERSISTENT_QUEUE       CONSTANT BINARY_INTEGER := 2;

  -- non-repudiation properties
  NON_REPUDIATE_SENDER       CONSTANT BINARY_INTEGER := 1;
  NON_REPUDIATE_SNDRCV       CONSTANT BINARY_INTEGER := 2;

  -- protocols (note that FTP is not supported yet so it is not
  -- included in anyp). 
  TTC      CONSTANT BINARY_INTEGER := 0;
  HTTP      CONSTANT BINARY_INTEGER := 1;
  SMTP      CONSTANT BINARY_INTEGER := 2;
  FTP       CONSTANT BINARY_INTEGER := 4;
  ANYP      CONSTANT BINARY_INTEGER := HTTP + SMTP;
  
  LOGMINER_PROTOCOL  CONSTANT BINARY_INTEGER := 1;
  LOGAPPLY_PROTOCOL  CONSTANT BINARY_INTEGER := 2;
  TEST_PROTOCOL      CONSTANT BINARY_INTEGER := 3;  

  -- Constants for LDAP connection factory type
  AQ_QUEUE_CONNECTION  CONSTANT BINARY_INTEGER := 1;
  AQ_TOPIC_CONNECTION  CONSTANT BINARY_INTEGER := 2;

  -- Constants for delivery mode
  PERSISTENT         CONSTANT BINARY_INTEGER := 1 ;
  BUFFERED           CONSTANT BINARY_INTEGER := 2 ;
  PERSISTENT_OR_BUFFERED   CONSTANT BINARY_INTEGER := 3 ;

  -- subscriber properties. 
  QUEUE_TO_QUEUE_SUBSCRIBER          CONSTANT BINARY_INTEGER := 8;  

  -- Constants for get/set_replay_info
  LAST_ENQUEUED      CONSTANT BINARY_INTEGER := 0;
  LAST_ACKNOWLEDGED  CONSTANT BINARY_INTEGER := 1; 
  
  TYPE col_tab IS TABLE OF VARCHAR2(30)
    INDEX BY BINARY_INTEGER;

  TYPE aq$_subscriber_list_t IS TABLE OF sys.aq$_agent
    INDEX BY BINARY_INTEGER;

  TYPE aq$_purge_options_t IS
     RECORD(block          boolean      DEFAULT FALSE,
            delivery_mode  PLS_INTEGER  DEFAULT PERSISTENT);

  -- Internal type to store columns of shard$_map_table
  TYPE map_row IS RECORD ( 
               schema               VARCHAR2(30),
               logical_qt           VARCHAR2(30),
               physical_qt          VARCHAR2(30),
               logical_queue        VARCHAR2(30) DEFAULT NULL,
               physical_queue       VARCHAR2(30) DEFAULT NULL,
               primary_inst         NUMBER,
               secondary_inst       NUMBER,
               unshrd_in_progress   NUMBER );

    TYPE map_table_arr IS TABLE OF map_row INDEX BY BINARY_INTEGER;

  --Internal type for physical_qt

  TYPE qt_list IS TABLE OF varchar2(30) INDEX BY BINARY_INTEGER;

  -- Internal procedure used by wrapper package to parse queue/queue table name
  PROCEDURE parse_name( 
             full_name         IN    VARCHAR2,
             canon_schema      OUT   VARCHAR2,
             canon_name        OUT   VARCHAR2,
             schema_indx       IN    BOOLEAN DEFAULT TRUE);

  PROCEDURE make_sharded_queue(qt_name IN VARCHAR2);

  PROCEDURE alter_map_table(
              queue_table          IN     VARCHAR2,
              primary_instance     IN     BINARY_INTEGER DEFAULT NULL,
              secondary_instance   IN     BINARY_INTEGER DEFAULT NULL);

  PROCEDURE create_queue_table(
              queue_table          IN   VARCHAR2,
              queue_payload_type   IN   VARCHAR2 ,
              storage_clause       IN   VARCHAR2        DEFAULT NULL,
              sort_list            IN   VARCHAR2        DEFAULT NULL,
              multiple_consumers   IN   BOOLEAN         DEFAULT FALSE,
              message_grouping     IN   BINARY_INTEGER  DEFAULT NONE,
              comment              IN   VARCHAR2        DEFAULT NULL,
              primary_instance     IN   BINARY_INTEGER  DEFAULT 0,
              secondary_instance   IN   BINARY_INTEGER  DEFAULT 0,
              compatible           IN   VARCHAR2        DEFAULT NULL,
              secure               IN   BOOLEAN         DEFAULT FALSE);

  PROCEDURE alter_queue_table(
        queue_table                IN   VARCHAR2,
        comment                    IN   VARCHAR2        DEFAULT NULL,
        primary_instance           IN   BINARY_INTEGER  DEFAULT NULL,
        secondary_instance         IN   BINARY_INTEGER  DEFAULT NULL);

  PROCEDURE create_queue(
        queue_name                 IN   VARCHAR2,
        queue_table                IN   VARCHAR2,
        queue_type                 IN   BINARY_INTEGER  DEFAULT NORMAL_QUEUE,
        max_retries                IN   NUMBER          DEFAULT NULL,
        retry_delay                IN   NUMBER          DEFAULT 0,
        retention_time             IN   NUMBER          DEFAULT 0,
        dependency_tracking        IN   BOOLEAN         DEFAULT FALSE,
        comment                    IN   VARCHAR2        DEFAULT NULL,
        auto_commit                IN   BOOLEAN         DEFAULT TRUE);

  PROCEDURE drop_queue(
        queue_name                 IN   VARCHAR2,
        auto_commit                IN   BOOLEAN         DEFAULT TRUE);

  PROCEDURE drop_queue_table(
        queue_table                IN   VARCHAR2,
        force                      IN   BOOLEAN         DEFAULT FALSE,
        auto_commit                IN   BOOLEAN         DEFAULT TRUE);

  PROCEDURE start_queue(
        queue_name                 IN   VARCHAR2,
        enqueue                    IN   BOOLEAN         DEFAULT TRUE,
        dequeue                    IN   BOOLEAN         DEFAULT TRUE);

  PROCEDURE stop_queue(
        queue_name                 IN   VARCHAR2,
        enqueue                    IN   BOOLEAN         DEFAULT TRUE,
        dequeue                    IN   BOOLEAN         DEFAULT TRUE,
        wait                       IN   BOOLEAN         DEFAULT TRUE);

  PROCEDURE alter_queue(
        queue_name                 IN   VARCHAR2,
        max_retries                IN   NUMBER          DEFAULT NULL,
        retry_delay                IN   NUMBER          DEFAULT NULL,
        retention_time             IN   NUMBER          DEFAULT NULL,
        auto_commit                IN   BOOLEAN         DEFAULT TRUE,
        comment                    IN   VARCHAR2        DEFAULT NULL);

  PROCEDURE add_subscriber(
        queue_name                 IN   VARCHAR2,
        subscriber                 IN   SYS.AQ$_AGENT,
        rule                       IN   VARCHAR2        DEFAULT NULL,
        transformation             IN   VARCHAR2        DEFAULT NULL,
        queue_to_queue             IN   BOOLEAN         DEFAULT FALSE,
        delivery_mode              IN   PLS_INTEGER     DEFAULT PERSISTENT);

  PROCEDURE alter_subscriber(
        queue_name                 IN   VARCHAR2,
        subscriber                 IN   SYS.AQ$_AGENT,
        rule                       IN   VARCHAR2,
        transformation             IN   VARCHAR2);

  PROCEDURE remove_subscriber(
        queue_name                 IN    VARCHAR2,
        subscriber                 IN   SYS.AQ$_AGENT);

  FUNCTION queue_subscribers(
        queue_name                 IN   VARCHAR2)
        RETURN aq$_subscriber_list_t;

  PROCEDURE grant_queue_privilege(
        privilege                  IN   VARCHAR2,
        queue_name                 IN   VARCHAR2,
        grantee                    IN   VARCHAR2,
        grant_option               IN   BOOLEAN := FALSE);
   
  PROCEDURE grant_system_privilege(
        privilege                  IN   VARCHAR2,
        grantee                    IN   VARCHAR2,
        admin_option               IN   BOOLEAN := FALSE);

   PROCEDURE revoke_queue_privilege(
        privilege                  IN   VARCHAR2,
        queue_name                 IN   VARCHAR2,
        grantee                    IN   VARCHAR2);

  PROCEDURE revoke_system_privilege(
        privilege                  IN   VARCHAR2,
        grantee                    IN   VARCHAR2);

   PROCEDURE get_type_info(
        schema                      IN     VARCHAR2,
        qname                       IN     VARCHAR2,
        gettds                      IN     BOOLEAN,
        rc                          OUT    BINARY_INTEGER,
        toid                        OUT    RAW,
        version                     OUT    NUMBER,
        tds                         OUT    LONG RAW, 
        queue_style                 OUT    VARCHAR2,
        network_name                OUT    VARCHAR2);

  PROCEDURE get_type_info(
        schema                      IN     VARCHAR2,
        qname                       IN     VARCHAR2,
        gettds                      IN     BOOLEAN,
        rc                          OUT    BINARY_INTEGER,
        toid                        OUT    RAW,
        version                     OUT    NUMBER,
        tds                         OUT    LONG RAW);

  PROCEDURE verify_queue_types(
        src_queue_name             IN   VARCHAR2,
        dest_queue_name            IN   VARCHAR2,
        destination                IN   VARCHAR2   DEFAULT NULL,
        rc                         OUT  BINARY_INTEGER,
        transformation             IN   VARCHAR2 DEFAULT NULL);

    PROCEDURE verify_queue_types_no_queue(
        src_queue_name             IN   VARCHAR2,
        dest_queue_name            IN   VARCHAR2,
        destination                IN   VARCHAR2 DEFAULT NULL,
        rc                         OUT  BINARY_INTEGER,
        transformation             IN   VARCHAR2 DEFAULT NULL);

  PROCEDURE verify_queue_types_get_nrp(
        src_queue_name             IN   VARCHAR2,
        dest_queue_name            IN   VARCHAR2,
        destination                IN   VARCHAR2 DEFAULT NULL,
        rc                         OUT  BINARY_INTEGER,
        transformation             IN   VARCHAR2 DEFAULT NULL);
 
   PROCEDURE get_prop_seqno(qid    IN   BINARY_INTEGER,
                           dqname  IN   VARCHAR2,
                           dbname  IN    VARCHAR2,
                           seq     OUT   BINARY_INTEGER);

  PROCEDURE recover_propagation(
        schema                    IN      VARCHAR2,
        queue_name                IN      VARCHAR2,
        destination               IN      VARCHAR2,
        protocol                  IN      BINARY_INTEGER default TTC,
        url                       IN      VARCHAR2 default NULL,
        username                  IN      VARCHAR2 default NULL,
        passwd                    IN      VARCHAR2 default NULL, 
        trace                     IN      BINARY_INTEGER default 0,
        destq                     IN      BINARY_INTEGER default 0);

  
  PROCEDURE schedule_propagation(
    queue_name                     IN   VARCHAR2,
    destination                    IN   VARCHAR2        DEFAULT NULL,
    start_time                     IN   TIMESTAMP WITH TIME ZONE DEFAULT NULL,
    duration                       IN   NUMBER          DEFAULT NULL,
    next_time                      IN   VARCHAR2        DEFAULT NULL,
    latency                        IN   NUMBER          DEFAULT 60,
    destination_queue              IN   VARCHAR2        DEFAULT NULL);

  PROCEDURE unschedule_propagation(
        queue_name                 IN   VARCHAR2,
        destination                IN   VARCHAR2        DEFAULT NULL,
        destination_queue          IN   VARCHAR2        DEFAULT NULL);

  PROCEDURE alter_propagation_schedule(
        queue_name                 IN   VARCHAR2,
        destination                IN   VARCHAR2        DEFAULT NULL,
        duration                   IN   NUMBER          DEFAULT NULL,
        next_time                  IN   VARCHAR2        DEFAULT NULL,
        latency                    IN   NUMBER          DEFAULT 60,
        destination_queue          IN   VARCHAR2        DEFAULT NULL);

  PROCEDURE enable_propagation_schedule(
        queue_name                 IN   VARCHAR2,
        destination                IN   VARCHAR2        DEFAULT NULL,
        destination_queue          IN   VARCHAR2        DEFAULT NULL);

  PROCEDURE disable_propagation_schedule(
        queue_name                 IN   VARCHAR2,
        destination                IN   VARCHAR2        DEFAULT NULL,
        destination_queue          IN   VARCHAR2        DEFAULT NULL);

  PROCEDURE start_time_manager;

  PROCEDURE stop_time_manager;

  PROCEDURE migrate_queue_table(
         queue_table              IN    VARCHAR2,
         compatible               IN    VARCHAR2);
 
  PROCEDURE set_watermark(
         wmvalue                  IN    NUMBER);

  PROCEDURE get_watermark(
         wmvalue                  OUT   NUMBER);

  -- add an alias to LDAP
  PROCEDURE add_alias_to_ldap(
            alias                  IN   VARCHAR2,
            obj_location           IN   VARCHAR2);

  -- drop an alias from LDAP
  PROCEDURE del_alias_from_ldap(
            alias                  IN   VARCHAR2);
  
  -- AQ Authorization management procedures
  PROCEDURE create_aq_agent (
            agent_name             IN   VARCHAR2,
            certificate_location   IN   VARCHAR2        DEFAULT NULL,
            enable_http            IN   BOOLEAN         DEFAULT FALSE,
            enable_smtp            IN   BOOLEAN         DEFAULT FALSE,
            enable_anyp            IN   BOOLEAN         DEFAULT FALSE);
  
  PROCEDURE alter_aq_agent(
            agent_name             IN   VARCHAR2,
            certificate_location   IN   VARCHAR2        DEFAULT NULL,
            enable_http            IN   BOOLEAN         DEFAULT FALSE,
            enable_smtp            IN   BOOLEAN         DEFAULT FALSE,
            enable_anyp            IN   BOOLEAN         DEFAULT FALSE);
  
  PROCEDURE drop_aq_agent (
            agent_name             IN   VARCHAR2 );
  
  PROCEDURE enable_db_access (
            agent_name             IN   VARCHAR2,
            db_username            IN   VARCHAR2   );

  PROCEDURE disable_db_access (
            agent_name             IN   VARCHAR2,
            db_username            IN   VARCHAR2   );

   -- enable jms types IN anydata queue tables
  PROCEDURE enable_jms_types(
            queue_table            IN   VARCHAR2);

  -- add a connection string to LDAP directory
  PROCEDURE add_connection_to_ldap(   
            connection          IN       VARCHAR2,
            host                IN       VARCHAR2,
            port                IN       BINARY_INTEGER, 
            sid                 IN       VARCHAR2,
            driver              IN       VARCHAR2 default NULL,
            type                IN       BINARY_INTEGER DEFAULT
                                         AQ_QUEUE_CONNECTION);
  -- add a connection string to LDAP directory
  PROCEDURE add_connection_to_ldap(
            connection          IN       VARCHAR2,  
            jdbc_string         IN       VARCHAR2,
            username            IN       VARCHAR2 default NULL,
            password            IN       VARCHAR2 default NULL,
            type                IN       BINARY_INTEGER DEFAULT
                                         AQ_QUEUE_CONNECTION);
  
  -- drop a connection string from LDAP directory
  PROCEDURE del_connection_from_ldap(
            connection          IN          VARCHAR2);

   -- purge queue table
  
  PROCEDURE purge_queue_table(
            queue_table            IN   VARCHAR2,
            purge_condition        IN   VARCHAR2,
            purge_options          IN   aq$_purge_options_t); 

    -- get a sender's replay info
  PROCEDURE get_replay_info(
            queue_name               IN      VARCHAR2,
            sender_agent             IN      sys.aq$_agent,
            replay_attribute         IN      BINARY_INTEGER,
            correlation              OUT     VARCHAR2);

  -- reset sender's replay info
  PROCEDURE reset_replay_info(
            queue_name               IN      VARCHAR2,
            sender_agent             IN      sys.aq$_agent,
            replay_attribute         IN      BINARY_INTEGER);

  PROCEDURE cbk_rm_job(
            qt_schema              IN   VARCHAR2,
            qt_name                IN   VARCHAR2);

  PROCEDURE recover_sharded_queue(
            qt_name               IN    VARCHAR2);

  PROCEDURE remove_sharded_queue(
            qt_name                IN   VARCHAR2);


END dbms_aqadm_wrapper ;
/
show errors

CREATE OR REPLACE SYNONYM dbms_aqadm FOR dbms_aqadm_wrapper;
/

GRANT EXECUTE ON dbms_aqadm_wrapper TO PUBLIC
/

